/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import CH.ifa.draw.framework.DrawingView;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.util.BlockEnumerator;
import DE.siemens.ad.logo.util.ProgressListener;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.util.LayoutProducer;
import DE.siemens.ad.udf.EditUDFFigure;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.UDFBlockFigure;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

public class LayoutProducerUDF
extends LayoutProducer {
    public LayoutProducerUDF(DrawingView view, List blocks) {
        super(view, blocks);
    }

    protected void doLayout(int startX, int startY, ProgressListener progressListener) {
        int rowOffset = 0;
        int rowMax = 0;
        int rowLast = 0;
        Point startPoint = new Point(startX + this.fHorizontalDistance, startY);
        int row = 0;
        EditUDFFigure editUDFFigure = ((LogoDrawingUDF)this.fView.drawing()).getEditUDFFigure();
        int miniXLocation = editUDFFigure.getEditArea().x - editUDFFigure.getMiniFigureWidth() / 2;
        int miniLeftYLocation = editUDFFigure.getUDFLeftConnectorFigure().displayBox().y;
        int miniRightYLocation = editUDFFigure.getUDFLeftConnectorFigure().displayBox().y;
        for (int i = 0; i < this.fBlocks.length; ++i) {
            if (progressListener != null) {
                progressListener.increment(1);
            }
            rowLast = 0;
            rowOffset += rowMax;
            rowMax = 0;
            Block block = this.fBlocks[i];
            Block previousBlock = null;
            Block actBlock = null;
            InBlockConnector inBlockConnector = null;
            OutBlockConnector outBlockConnector = null;
            BlockEnumerator enumeration = new BlockEnumerator(block, false);
            while (enumeration.hasMoreElements()) {
                int column;
                actBlock = enumeration.nextBlock();
                if (!this.blockProcessed(actBlock, column = enumeration.getColumn())) {
                    if (column > this.fDepth) {
                        this.fDepth = column;
                    }
                    Point refPoint = new Point(startPoint);
                    row = enumeration.getRow();
                    if (row > rowLast) {
                        row = ++rowLast;
                    }
                    if (row > rowMax) {
                        rowMax = row;
                    }
                    refPoint.translate((column - 1) * this.fHorizontalDistance, (row - 1 + rowOffset) * this.fVerticalDistance);
                    BlockFigure f = null;
                    if (actBlock instanceof DeputyBlock) {
                        f = new UDFBlockFigure(((DeputyBlock)actBlock).getParent(), refPoint);
                        this.fView.add(f);
                    } else if (actBlock.getClass() == InputBlock.class || actBlock.getClass() == AnalogInputBlock.class) {
                        refPoint.x = miniXLocation;
                        refPoint.y = miniLeftYLocation += 20;
                        EditUDFFigure editUDFFigure2 = editUDFFigure;
                        editUDFFigure2.getClass();
                        f = editUDFFigure2.new EditUDFFigure.MiniBlockFigure(actBlock, refPoint);
                        editUDFFigure.getInputfigures().add(f);
                        editUDFFigure.add(f);
                    } else if (actBlock.getClass() == OutputBlock.class || actBlock.getClass() == AnalogOutputBlock.class) {
                        refPoint.x = miniXLocation + editUDFFigure.getEditArea().width;
                        refPoint.y = miniRightYLocation += 20;
                        EditUDFFigure editUDFFigure3 = editUDFFigure;
                        editUDFFigure3.getClass();
                        f = editUDFFigure3.new EditUDFFigure.MiniBlockFigure(actBlock, refPoint);
                        editUDFFigure.getOutputfigures().add(f);
                        editUDFFigure.add(f);
                    } else {
                        f = new BlockFigure(actBlock, refPoint);
                        this.fView.add(f);
                    }
                    f.moveAlignmentAnchorTo(refPoint);
                    this.fCreatedFigures.add(f);
                }
                if (previousBlock != null) {
                    inBlockConnector = enumeration.getInBlockConnector();
                    outBlockConnector = inBlockConnector.getLinkedConnector();
                    if (!(inBlockConnector.getOwner() instanceof DeputyBlock) && inBlockConnector.getOwner().getWiringDiagram().getMacroBlock(inBlockConnector.getOwner()) != null || !(outBlockConnector.getOwner() instanceof DeputyBlock) && outBlockConnector.getOwner().getWiringDiagram().getMacroBlock(outBlockConnector.getOwner()) != null) continue;
                    if (!this.fConnectionsToCreate.contains(inBlockConnector)) {
                        this.fConnectionsToCreate.add(inBlockConnector);
                    }
                }
                previousBlock = actBlock;
            }
        }
        this.moveBlocks(-startX - (this.fDepth + 1) * this.fHorizontalDistance);
        this.adaptPages((this.fDepth + 1) * -this.fHorizontalDistance, (row + rowOffset) * this.fVerticalDistance);
        this.createConnections();
        this.fView.checkDamage();
    }

    protected void moveBlocks(int xMove) {
        int size = this.fCreatedFigures.size();
        EditUDFFigure editUDFFigure = ((LogoDrawingUDF)this.fView.drawing()).getEditUDFFigure();
        Rectangle allRectangle = new Rectangle();
        for (int i = 0; i < size; ++i) {
            BlockFigure f = (BlockFigure)this.fCreatedFigures.get(i);
            if (this.fCreatedFigures.get(i) instanceof EditUDFFigure.MiniBlockFigure) continue;
            allRectangle.add(f.displayBox());
            f.moveBy(xMove, 0);
        }
        int width = editUDFFigure.getEditArea().width;
        int height = editUDFFigure.getEditArea().height;
        if (allRectangle.width > editUDFFigure.getEditArea().width) {
            width = allRectangle.width;
        }
        if (allRectangle.height > editUDFFigure.getEditArea().height) {
            height = allRectangle.height;
        }
        editUDFFigure.getUDFBoxFigure().displayBox(new Point(editUDFFigure.getEditArea().x, editUDFFigure.getEditArea().y), new Point(editUDFFigure.getEditArea().x + width, editUDFFigure.getEditArea().y + height));
    }
}

